﻿namespace Hims.Api.Models.Application
{
    using System.Collections.Generic;
    using Shared.Library.Enums;

    /// <summary>
    /// The verify mobile otp request.
    /// </summary>
    public class VerifyMobileOTPRequest
    {
        /// <summary>
        /// Gets or sets the account types.
        /// </summary>
        public IEnumerable<AccountType> AccountTypes { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets the country id.
        /// </summary>
        public int CountryId { get; set; }

        /// <summary>
        /// Gets or sets the OTP.
        /// </summary>
        public string OTP { get; set; }

        /// <summary>
        /// Gets or sets the device type.
        /// </summary>
        public DeviceType DeviceType { get; set; }

        /// <summary>
        /// Gets or sets the device key.
        /// </summary>
        public string DeviceToken { get; set; }

        /// <summary>
        /// Gets or sets the device id.
        /// </summary>
        public string DeviceId { get; set; }
    }
}
